/************************************************************************
 *
 *    Copyright  2002 Fonix Coporation. All rights reserved.
 *
 *    This is an unpublished work, and is confidential and proprietary: 
 *    technology and information of Fonix corporation.  No part of this
 *    code may be reproduced, used or disclosed without written consent of 
 *    Fonix corporation in each and every instance.
 *************************************************************************
 *    File Name:        log10table.c
 *    Author:
 *    Creation Date:
 *
 *    Functionality:
 *  
 *
 ***********************************************************************
 *    Revision History:
 *
 *	Rev Who     Date        Description
 *	--- ----	----------	--------------------------------------------  
 *	001	CAB		08/08/2002	Removed warning
 */

#include <math.h>

#ifdef ARM7
#pragma arm section code="LOGCODE", rodata="LOGRODATA"
#endif

// base-10 logarithm in the range of log[10] x =.001 to log[10] x = 10
const float log10table[]={
-3.00000000f, -2.00000000f, -1.69897000f, -1.52287875f, 
-1.39794001f, -1.30103000f, -1.22184875f, -1.15490196f, 
-1.09691001f, -1.04575749f, -1.00000000f, -0.95860731f, 
-0.92081875f, -0.88605665f, -0.85387196f, -0.82390874f, 
-0.79588002f, -0.76955108f, -0.74472749f, -0.72124640f, 
-0.69897000f, -0.67778071f, -0.65757732f, -0.63827216f, 
-0.61978876f, -0.60205999f, -0.58502665f, -0.56863624f, 
-0.55284197f, -0.53760200f, -0.52287875f, -0.50863831f, 
-0.49485002f, -0.48148606f, -0.46852108f, -0.45593196f, 
-0.44369750f, -0.43179828f, -0.42021640f, -0.40893539f, 
-0.39794001f, -0.38721614f, -0.37675071f, -0.36653154f, 
-0.35654732f, -0.34678749f, -0.33724217f, -0.32790214f, 
-0.31875876f, -0.30980392f, -0.30103000f, -0.29242982f, 
-0.28399666f, -0.27572413f, -0.26760624f, -0.25963731f, 
-0.25181197f, -0.24412514f, -0.23657201f, -0.22914799f, 
-0.22184875f, -0.21467016f, -0.20760831f, -0.20065945f, 
-0.19382003f, -0.18708664f, -0.18045606f, -0.17392520f, 
-0.16749109f, -0.16115091f, -0.15490196f, -0.14874165f, 
-0.14266750f, -0.13667714f, -0.13076828f, -0.12493874f, 
-0.11918641f, -0.11350927f, -0.10790540f, -0.10237291f, 
-0.09691001f, -0.09151498f, -0.08618615f, -0.08092191f, 
-0.07572071f, -0.07058107f, -0.06550155f, -0.06048075f, 
-0.05551733f, -0.05060999f, -0.04575749f, -0.04095861f, 
-0.03621217f, -0.03151705f, -0.02687215f, -0.02227639f, 
-0.01772877f, -0.01322827f, -0.00877392f, -0.00436481f, 
0.00000000f, 0.00432137f, 0.00860017f, 0.01283722f, 
0.01703334f, 0.02118930f, 0.02530587f, 0.02938378f, 
0.03342376f, 0.03742650f, 0.04139269f, 0.04532298f, 
0.04921802f, 0.05307844f, 0.05690485f, 0.06069784f, 
0.06445799f, 0.06818586f, 0.07188201f, 0.07554696f, 
0.07918125f, 0.08278537f, 0.08635983f, 0.08990511f, 
0.09342169f, 0.09691001f, 0.10037055f, 0.10380372f, 
0.10720997f, 0.11058971f, 0.11394335f, 0.11727130f, 
0.12057393f, 0.12385164f, 0.12710480f, 0.13033377f, 
0.13353891f, 0.13672057f, 0.13987909f, 0.14301480f, 
0.14612804f, 0.14921911f, 0.15228834f, 0.15533604f, 
0.15836249f, 0.16136800f, 0.16435286f, 0.16731733f, 
0.17026172f, 0.17318627f, 0.17609126f, 0.17897695f, 
0.18184359f, 0.18469143f, 0.18752072f, 0.19033170f, 
0.19312460f, 0.19589965f, 0.19865709f, 0.20139712f, 
0.20411998f, 0.20682588f, 0.20951501f, 0.21218760f, 
0.21484385f, 0.21748394f, 0.22010809f, 0.22271647f, 
0.22530928f, 0.22788670f, 0.23044892f, 0.23299611f, 
0.23552845f, 0.23804610f, 0.24054925f, 0.24303805f, 
0.24551267f, 0.24797327f, 0.25042000f, 0.25285303f, 
0.25527251f, 0.25767857f, 0.26007139f, 0.26245109f, 
0.26481782f, 0.26717173f, 0.26951294f, 0.27184161f, 
0.27415785f, 0.27646180f, 0.27875360f, 0.28103337f, 
0.28330123f, 0.28555731f, 0.28780173f, 0.29003461f, 
0.29225607f, 0.29446623f, 0.29666519f, 0.29885308f, 
0.30103000f, 0.30319606f, 0.30535137f, 0.30749604f, 
0.30963017f, 0.31175386f, 0.31386722f, 0.31597035f, 
0.31806333f, 0.32014629f, 0.32221929f, 0.32428246f, 
0.32633586f, 0.32837960f, 0.33041377f, 0.33243846f, 
0.33445375f, 0.33645973f, 0.33845649f, 0.34044411f, 
0.34242268f, 0.34439227f, 0.34635297f, 0.34830486f, 
0.35024802f, 0.35218252f, 0.35410844f, 0.35602586f, 
0.35793485f, 0.35983548f, 0.36172784f, 0.36361198f, 
0.36548798f, 0.36735592f, 0.36921586f, 0.37106786f, 
0.37291200f, 0.37474835f, 0.37657696f, 0.37839790f, 
0.38021124f, 0.38201704f, 0.38381537f, 0.38560627f, 
0.38738983f, 0.38916608f, 0.39093511f, 0.39269695f, 
0.39445168f, 0.39619935f, 0.39794001f, 0.39967372f, 
0.40140054f, 0.40312052f, 0.40483372f, 0.40654018f, 
0.40823997f, 0.40993312f, 0.41161971f, 0.41329976f, 
0.41497335f, 0.41664051f, 0.41830129f, 0.41995575f, 
0.42160393f, 0.42324587f, 0.42488164f, 0.42651126f, 
0.42813479f, 0.42975228f, 0.43136376f, 0.43296929f, 
0.43456890f, 0.43616265f, 0.43775056f, 0.43933269f, 
0.44090908f, 0.44247977f, 0.44404480f, 0.44560420f, 
0.44715803f, 0.44870632f, 0.45024911f, 0.45178644f, 
0.45331834f, 0.45484486f, 0.45636603f, 0.45788190f, 
0.45939249f, 0.46089784f, 0.46239800f, 0.46389299f, 
0.46538285f, 0.46686762f, 0.46834733f, 0.46982202f, 
0.47129171f, 0.47275645f, 0.47421626f, 0.47567119f, 
0.47712125f, 0.47856650f, 0.48000694f, 0.48144263f, 
0.48287358f, 0.48429984f, 0.48572143f, 0.48713838f, 
0.48855072f, 0.48995848f, 0.49136169f, 0.49276039f, 
0.49415459f, 0.49554434f, 0.49692965f, 0.49831055f, 
0.49968708f, 0.50105926f, 0.50242712f, 0.50379068f, 
0.50514998f, 0.50650503f, 0.50785587f, 0.50920252f, 
0.51054501f, 0.51188336f, 0.51321760f, 0.51454775f, 
0.51587384f, 0.51719590f, 0.51851394f, 0.51982799f, 
0.52113808f, 0.52244423f, 0.52374647f, 0.52504481f, 
0.52633928f, 0.52762990f, 0.52891670f, 0.53019970f, 
0.53147892f, 0.53275438f, 0.53402611f, 0.53529412f, 
0.53655844f, 0.53781910f, 0.53907610f, 0.54032947f, 
0.54157924f, 0.54282543f, 0.54406804f, 0.54530712f, 
0.54654266f, 0.54777471f, 0.54900326f, 0.55022835f, 
0.55145000f, 0.55266822f, 0.55388303f, 0.55509445f, 
0.55630250f, 0.55750720f, 0.55870857f, 0.55990663f, 
0.56110138f, 0.56229286f, 0.56348109f, 0.56466606f, 
0.56584782f, 0.56702637f, 0.56820172f, 0.56937391f, 
0.57054294f, 0.57170883f, 0.57287160f, 0.57403127f, 
0.57518784f, 0.57634135f, 0.57749180f, 0.57863921f, 
0.57978360f, 0.58092498f, 0.58206336f, 0.58319877f, 
0.58433122f, 0.58546073f, 0.58658730f, 0.58771097f, 
0.58883173f, 0.58994960f, 0.59106461f, 0.59217676f, 
0.59328607f, 0.59439255f, 0.59549622f, 0.59659710f, 
0.59769519f, 0.59879051f, 0.59988307f, 0.60097290f, 
0.60205999f, 0.60314437f, 0.60422605f, 0.60530505f, 
0.60638137f, 0.60745502f, 0.60852603f, 0.60959441f, 
0.61066016f, 0.61172331f, 0.61278386f, 0.61384182f, 
0.61489722f, 0.61595005f, 0.61700034f, 0.61804810f, 
0.61909333f, 0.62013605f, 0.62117628f, 0.62221402f, 
0.62324929f, 0.62428210f, 0.62531245f, 0.62634037f, 
0.62736586f, 0.62838893f, 0.62940960f, 0.63042788f, 
0.63144377f, 0.63245729f, 0.63346846f, 0.63447727f, 
0.63548375f, 0.63648790f, 0.63748973f, 0.63848926f, 
0.63948649f, 0.64048144f, 0.64147411f, 0.64246452f, 
0.64345268f, 0.64443859f, 0.64542227f, 0.64640373f, 
0.64738297f, 0.64836001f, 0.64933486f, 0.65030752f, 
0.65127801f, 0.65224634f, 0.65321251f, 0.65417654f, 
0.65513843f, 0.65609820f, 0.65705585f, 0.65801140f, 
0.65896484f, 0.65991620f, 0.66086548f, 0.66181269f, 
0.66275783f, 0.66370093f, 0.66464198f, 0.66558099f, 
0.66651798f, 0.66745295f, 0.66838592f, 0.66931688f, 
0.67024585f, 0.67117284f, 0.67209786f, 0.67302091f, 
0.67394200f, 0.67486114f, 0.67577834f, 0.67669361f, 
0.67760695f, 0.67851838f, 0.67942790f, 0.68033551f, 
0.68124124f, 0.68214508f, 0.68304704f, 0.68394713f, 
0.68484536f, 0.68574174f, 0.68663627f, 0.68752896f, 
0.68841982f, 0.68930886f, 0.69019608f, 0.69108149f, 
0.69196510f, 0.69284692f, 0.69372695f, 0.69460520f, 
0.69548168f, 0.69635639f, 0.69722934f, 0.69810055f, 
0.69897000f, 0.69983773f, 0.70070372f, 0.70156799f, 
0.70243054f, 0.70329138f, 0.70415052f, 0.70500796f, 
0.70586371f, 0.70671778f, 0.70757018f, 0.70842090f, 
0.70926996f, 0.71011737f, 0.71096312f, 0.71180723f, 
0.71264970f, 0.71349054f, 0.71432976f, 0.71516736f, 
0.71600334f, 0.71683772f, 0.71767050f, 0.71850169f, 
0.71933129f, 0.72015930f, 0.72098574f, 0.72181062f, 
0.72263392f, 0.72345567f, 0.72427587f, 0.72509452f, 
0.72591163f, 0.72672721f, 0.72754126f, 0.72835378f, 
0.72916479f, 0.72997429f, 0.73078228f, 0.73158877f, 
0.73239376f, 0.73319727f, 0.73399929f, 0.73479983f, 
0.73559890f, 0.73639650f, 0.73719264f, 0.73798733f, 
0.73878056f, 0.73957234f, 0.74036269f, 0.74115160f, 
0.74193908f, 0.74272513f, 0.74350976f, 0.74429298f, 
0.74507479f, 0.74585520f, 0.74663420f, 0.74741181f, 
0.74818803f, 0.74896286f, 0.74973632f, 0.75050839f, 
0.75127910f, 0.75204845f, 0.75281643f, 0.75358306f, 
0.75434834f, 0.75511227f, 0.75587486f, 0.75663611f, 
0.75739603f, 0.75815462f, 0.75891189f, 0.75966784f, 
0.76042248f, 0.76117581f, 0.76192784f, 0.76267856f, 
0.76342799f, 0.76417613f, 0.76492298f, 0.76566855f, 
0.76641285f, 0.76715587f, 0.76789762f, 0.76863810f, 
0.76937733f, 0.77011529f, 0.77085201f, 0.77158748f, 
0.77232171f, 0.77305469f, 0.77378644f, 0.77451697f, 
0.77524626f, 0.77597433f, 0.77670118f, 0.77742682f, 
0.77815125f, 0.77887447f, 0.77959649f, 0.78031731f, 
0.78103694f, 0.78175537f, 0.78247262f, 0.78318869f, 
0.78390358f, 0.78461729f, 0.78532984f, 0.78604121f, 
0.78675142f, 0.78746047f, 0.78816837f, 0.78887512f, 
0.78958071f, 0.79028516f, 0.79098848f, 0.79169065f, 
0.79239169f, 0.79309160f, 0.79379038f, 0.79448805f, 
0.79518459f, 0.79588002f, 0.79657433f, 0.79726754f, 
0.79795964f, 0.79865065f, 0.79934055f, 0.80002936f, 
0.80071708f, 0.80140371f, 0.80208926f, 0.80277373f, 
0.80345712f, 0.80413943f, 0.80482068f, 0.80550086f, 
0.80617997f, 0.80685803f, 0.80753503f, 0.80821097f, 
0.80888587f, 0.80955971f, 0.81023252f, 0.81090428f, 
0.81157501f, 0.81224470f, 0.81291336f, 0.81358099f, 
0.81424760f, 0.81491318f, 0.81557775f, 0.81624130f, 
0.81690384f, 0.81756537f, 0.81822589f, 0.81888541f, 
0.81954394f, 0.82020146f, 0.82085799f, 0.82151353f, 
0.82216808f, 0.82282165f, 0.82347423f, 0.82412583f, 
0.82477646f, 0.82542612f, 0.82607480f, 0.82672252f, 
0.82736927f, 0.82801506f, 0.82865990f, 0.82930377f, 
0.82994670f, 0.83058867f, 0.83122969f, 0.83186977f, 
0.83250891f, 0.83314711f, 0.83378437f, 0.83442070f, 
0.83505610f, 0.83569057f, 0.83632412f, 0.83695674f, 
0.83758844f, 0.83821922f, 0.83884909f, 0.83947805f, 
0.84010609f, 0.84073323f, 0.84135947f, 0.84198480f, 
0.84260924f, 0.84323278f, 0.84385542f, 0.84447718f, 
0.84509804f, 0.84571802f, 0.84633711f, 0.84695533f, 
0.84757266f, 0.84818912f, 0.84880470f, 0.84941941f, 
0.85003326f, 0.85064624f, 0.85125835f, 0.85186960f, 
0.85247999f, 0.85308953f, 0.85369821f, 0.85430604f, 
0.85491302f, 0.85551916f, 0.85612444f, 0.85672889f, 
0.85733250f, 0.85793526f, 0.85853720f, 0.85913830f, 
0.85973857f, 0.86033801f, 0.86093662f, 0.86153441f, 
0.86213138f, 0.86272753f, 0.86332286f, 0.86391738f, 
0.86451108f, 0.86510397f, 0.86569606f, 0.86628734f, 
0.86687781f, 0.86746749f, 0.86805636f, 0.86864444f, 
0.86923172f, 0.86981821f, 0.87040391f, 0.87098881f, 
0.87157294f, 0.87215627f, 0.87273883f, 0.87332060f, 
0.87390160f, 0.87448182f, 0.87506126f, 0.87563994f, 
0.87621784f, 0.87679498f, 0.87737135f, 0.87794695f, 
0.87852180f, 0.87909588f, 0.87966921f, 0.88024178f, 
0.88081359f, 0.88138466f, 0.88195497f, 0.88252454f, 
0.88309336f, 0.88366144f, 0.88422877f, 0.88479536f, 
0.88536122f, 0.88592634f, 0.88649073f, 0.88705438f, 
0.88761730f, 0.88817949f, 0.88874096f, 0.88930170f, 
0.88986172f, 0.89042102f, 0.89097960f, 0.89153746f, 
0.89209460f, 0.89265103f, 0.89320675f, 0.89376176f, 
0.89431606f, 0.89486966f, 0.89542255f, 0.89597473f, 
0.89652622f, 0.89707700f, 0.89762709f, 0.89817648f, 
0.89872518f, 0.89927319f, 0.89982050f, 0.90036713f, 
0.90091307f, 0.90145832f, 0.90200289f, 0.90254678f, 
0.90308999f, 0.90363252f, 0.90417437f, 0.90471555f, 
0.90525605f, 0.90579588f, 0.90633504f, 0.90687353f, 
0.90741136f, 0.90794852f, 0.90848502f, 0.90902085f, 
0.90955603f, 0.91009055f, 0.91062440f, 0.91115761f, 
0.91169016f, 0.91222206f, 0.91275330f, 0.91328390f, 
0.91381385f, 0.91434316f, 0.91487182f, 0.91539984f, 
0.91592721f, 0.91645395f, 0.91698005f, 0.91750551f, 
0.91803034f, 0.91855453f, 0.91907809f, 0.91960102f, 
0.92012333f, 0.92064500f, 0.92116605f, 0.92168648f, 
0.92220628f, 0.92272546f, 0.92324402f, 0.92376196f, 
0.92427929f, 0.92479600f, 0.92531209f, 0.92582757f, 
0.92634245f, 0.92685671f, 0.92737036f, 0.92788341f, 
0.92839585f, 0.92890769f, 0.92941893f, 0.92992956f, 
0.93043959f, 0.93094903f, 0.93145787f, 0.93196611f, 
0.93247376f, 0.93298082f, 0.93348729f, 0.93399316f, 
0.93449845f, 0.93500315f, 0.93550727f, 0.93601080f, 
0.93651374f, 0.93701611f, 0.93751789f, 0.93801910f, 
0.93851973f, 0.93901978f, 0.93951925f, 0.94001816f, 
0.94051648f, 0.94101424f, 0.94151143f, 0.94200805f, 
0.94250411f, 0.94299959f, 0.94349452f, 0.94398888f, 
0.94448267f, 0.94497591f, 0.94546859f, 0.94596070f, 
0.94645227f, 0.94694327f, 0.94743372f, 0.94792362f, 
0.94841297f, 0.94890176f, 0.94939001f, 0.94987770f, 
0.95036485f, 0.95085146f, 0.95133752f, 0.95182304f, 
0.95230801f, 0.95279244f, 0.95327634f, 0.95375969f, 
0.95424251f, 0.95472479f, 0.95520654f, 0.95568775f, 
0.95616843f, 0.95664858f, 0.95712820f, 0.95760729f, 
0.95808585f, 0.95856388f, 0.95904139f, 0.95951838f, 
0.95999484f, 0.96047078f, 0.96094620f, 0.96142109f, 
0.96189547f, 0.96236934f, 0.96284268f, 0.96331551f, 
0.96378783f, 0.96425963f, 0.96473092f, 0.96520170f, 
0.96567197f, 0.96614173f, 0.96661099f, 0.96707973f, 
0.96754798f, 0.96801571f, 0.96848295f, 0.96894968f, 
0.96941591f, 0.96988164f, 0.97034688f, 0.97081161f, 
0.97127585f, 0.97173959f, 0.97220284f, 0.97266559f, 
0.97312785f, 0.97358962f, 0.97405090f, 0.97451169f, 
0.97497199f, 0.97543181f, 0.97589114f, 0.97634998f, 
0.97680834f, 0.97726621f, 0.97772361f, 0.97818052f, 
0.97863695f, 0.97909290f, 0.97954837f, 0.98000337f, 
0.98045789f, 0.98091194f, 0.98136551f, 0.98181861f, 
0.98227123f, 0.98272339f, 0.98317507f, 0.98362629f, 
0.98407703f, 0.98452731f, 0.98497713f, 0.98542647f, 
0.98587536f, 0.98632378f, 0.98677173f, 0.98721923f, 
0.98766626f, 0.98811284f, 0.98855896f, 0.98900462f, 
0.98944982f, 0.98989456f, 0.99033885f, 0.99078269f, 
0.99122608f, 0.99166901f, 0.99211149f, 0.99255352f, 
0.99299510f, 0.99343623f, 0.99387691f, 0.99431715f, 
0.99475694f, 0.99519629f, 0.99563519f, 0.99607365f, 
0.99651167f, 0.99694925f, 0.99738638f, 0.99782308f, 
0.99825934f, 0.99869516f, 0.99913054f, 0.99956549f, 
1.00000000f};

/* ******************************************************************
 *      Function Name: DT_f_log10()
 *
 *      Description: Returns the base-10 logarithm
 *
 *      Arguments: float input	Value to find the log[10]
 *
 *      Return Value: float
 *
 *      Comments: if value falls with range of data in log10table use 
 *				  the array otherwise use log10()
 * *****************************************************************/
float DT_f_log10(float input)
{	int pos;

	if (input>100.0f)
	{	// CAB 08/08/2002	Removed warning
		return (float)(log10(input));
	}

	if (input>10.0f)
	{	// CAB 08/08/2002	Removed warning
		pos=(int)(input*10.0f);
		return (log10table[pos]+1);
	}

	pos=(int)(input*100.0f);
	return(log10table[pos]);
}